<?php require_once 'classloader.php'; ?>

<?php 
if (!$userObj->isLoggedIn()) {
  header("Location: login.php");
}

if ($userObj->isAdmin()) {
  header("Location: ../client/index.php");
}
?>

<!doctype html>
  <html lang="en">
  <head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Instrument+Sans:wght@400;600&display=swap" rel="stylesheet">

    <style>
      :root {
        --primary: #6CA6CD; 
        --accent: #F2C94C;  
        --light: #FDFDF6; 
      }
      body {
        font-family: 'Instrument Sans', sans-serif;
      }
      .bg-primary { background-color: var(--primary); }
      .bg-accent { background-color: var(--accent); }
      .bg-light { background-color: var(--light); }
      .text-primary { color: var(--primary); }
    </style>
  </head>
  <body class="bg-light min-h-screen flex flex-col">
    <?php include 'includes/navbar.php'; ?>

    <!-- main content -->
    <main class="container mx-auto px-6 py-12 flex-grow">
      <h2 class="text-2xl font-semibold text-primary text-center mb-10">Your Proposals (Double click to edit)</h2>

      <div class="text-center mb-6">
        <?php  
          if (isset($_SESSION['message']) && isset($_SESSION['status'])) {
            if ($_SESSION['status'] == "200") {
              echo "<div class='bg-green-100 text-green-800 border border-green-300 px-4 py-3 rounded-lg'>{$_SESSION['message']}</div>";
            } else {
              echo "<div class='bg-red-100 text-red-800 border border-red-300 px-4 py-3 rounded-lg'>{$_SESSION['message']}</div>"; 
            }
            unset($_SESSION['message']);
            unset($_SESSION['status']);
          }
        ?>
      </div>

      <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8 max-w-7xl mx-auto">
        <?php $getProposalsByUserID = $proposalObj->getProposalsByUserID($_SESSION['user_id']); ?>
        <?php foreach ($getProposalsByUserID as $proposal) { ?>
        <div class="proposalCard bg-white border border-gray-200 rounded-2xl shadow-md">
          <div class="p-6">
            <img src="<?php echo "../images/".$proposal['image']; ?>" class="w-full h-48 object-cover rounded-lg mb-4" alt="">
            <p class="text-sm text-gray-500 mb-2"><i><?php echo date("F j, Y, g:i a", strtotime($proposal['proposals_date_added'])); ?></i></p>
            <p class="text-gray-700 mb-3"><?php echo $proposal['description']; ?></p>
            <h4 class="text-lg font-semibold text-primary mb-4"><i><?php echo number_format($proposal['min_price']) . " - " . number_format($proposal['max_price']);?> PHP</i></h4>
            
            <form action="core/handleForms.php" method="POST" class="mb-2">
              <input type="hidden" name="proposal_id" value="<?php echo $proposal['proposal_id']; ?>">
              <input type="hidden" name="image" value="<?php echo $proposal['image']; ?>">
              <button type="submit" name="deleteProposalBtn" class="w-full text-red-500 hover:underline text-sm text-right">Delete</button>
            </form>

            <form action="core/handleForms.php" method="POST" class="updateProposalForm hidden space-y-4 mt-4">
              <input type="hidden" name="proposal_id" value="<?php echo $proposal['proposal_id']; ?>">
              <div class="grid grid-cols-2 gap-4">
                <div>
                  <label for="min_price" class="block text-sm font-medium text-gray-700">Min Price</label>
                  <input type="number" name="min_price" value="<?php echo $proposal['min_price']; ?>" class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-primary focus:border-primary">
                </div>
                <div>
                  <label for="max_price" class="block text-sm font-medium text-gray-700">Max Price</label>
                  <input type="number" name="max_price" value="<?php echo $proposal['max_price']; ?>" class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-primary focus:border-primary">
                </div>
              </div>
              <div>
                <label for="category_id" class="block text-sm font-medium text-gray-700">Category</label>
                <select name="category_id" class="category_id mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-primary focus:border-primary" required>
                    <option value="">Select Category</option>
                    <?php
                    $categories = $categoryObj->getCategories();
                    foreach ($categories as $cat) {
                        $selected = ($proposal['category_id'] == $cat['category_id']) ? 'selected' : '';
                        echo "<option value='{$cat['category_id']}' {$selected}>{$cat['category_name']}</option>";
                    }
                    ?>
                </select>
              </div>
              <div>
                <label for="subcategory_id" class="block text-sm font-medium text-gray-700">Subcategory</label>
                <select name="subcategory_id" class="subcategory_id mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-primary focus:border-primary" required>
                    <option value="">Select Subcategory</option>
                    <?php
                    $subcategories = $subcategoryObj->getSubcategories();
                    foreach ($subcategories as $subcat) {
                        $selected = ($proposal['subcategory_id'] == $subcat['subcategory_id']) ? 'selected' : '';
                        echo "<option value='{$subcat['subcategory_id']}' {$selected}>{$subcat['subcategory_name']}</option>";
                    }
                    ?>
                </select>
              </div>
              <div>
                <label for="description" class="block text-sm font-medium text-gray-700">Description</label>
                <textarea name="description" rows="3" class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-primary focus:border-primary"><?php echo $proposal['description']; ?></textarea>
              </div>
              <button type="submit" name="updateProposalBtn" class="w-full flex justify-center py-2 px-4 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-primary hover:bg-primary-dark focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary">
                Update Proposal
              </button>
            </form>
          </div>
        </div>
        <?php } ?>
      </div>
    </main>

    <script src="https://code.jquery.com/jquery-3.7.0.js"></script>
    <script>
       $('.proposalCard').on('dblclick', function (event) {
          var updateProposalForm = $(this).find('.updateProposalForm');
          updateProposalForm.toggleClass('hidden');
        });

        $('.category_id').on('change', function(){
            var categoryID = $(this).val();
            var subcategorySelect = $(this).closest('form').find('.subcategory_id');
            if(categoryID){
                $.ajax({
                    type:'GET',
                    url:'../../1_api/admin/ajax_get_subcategories.php',
                    data:'category_id='+categoryID,
                    success:function(data){
                        subcategorySelect.html('<option value="">Select Subcategory</option>'); 
                        $.each(data, function(index, value) {
                            subcategorySelect.append('<option value="'+ value.subcategory_id +'">'+ value.subcategory_name +'</option>');
                        });
                    }
                }); 
            }else{
                subcategorySelect.html('<option value="">Select Category First</option>');
            }
        });
    </script>
  </body>
</html>