<?php require_once 'classloader.php'; ?>
<?php 
if (!$userObj->isLoggedIn()) {
  header("Location: login.php");
}

if ($userObj->isAdmin()) {
  header("Location: ../client/index.php");
}  
?>
<!doctype html>
  <html lang="en">
  <head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Instrument+Sans:wght@400;600&display=swap" rel="stylesheet">

    <style>
      :root {
        --primary: #6CA6CD; 
        --accent: #F2C94C;  
        --light: #FDFDF6; 
      }
      body {
        font-family: 'Instrument Sans', sans-serif;
      }
      .bg-primary { background-color: var(--primary); }
      .bg-accent { background-color: var(--accent); }
      .bg-light { background-color: var(--light); }
      .text-primary { color: var(--primary); }
    </style>
  </head>
  <body class="bg-light min-h-screen flex flex-col">
    <?php include 'includes/navbar.php'; ?>

    <!-- main content -->
    <main class="container mx-auto px-6 py-12 flex-grow">
      <h2 class="text-2xl font-semibold text-primary text-center mb-10">Offers From Clients</h2>

      <div class="space-y-8 max-w-7xl mx-auto">
        <?php $getProposalsByUserID = $proposalObj->getProposalsByUserID($_SESSION['user_id']); ?>
        <?php foreach ($getProposalsByUserID as $proposal) { ?>
        <div class="bg-white border border-gray-200 rounded-2xl shadow-md">
          <div class="p-6">
            <div class="grid md:grid-cols-3 gap-6">
              <div class="md:col-span-1">
                <img src="<?php echo '../images/'.$proposal['image']; ?>" class="w-full h-auto object-cover rounded-lg" alt="">
              </div>
              <div class="md:col-span-2">
                <h3 class="text-xl font-semibold text-primary"><?php echo $proposal['description']; ?></h3>
                <p class="text-sm text-gray-500 mb-2"><i><?php echo date("F j, Y, g:i a", strtotime($proposal['proposals_date_added'])); ?></i></p>
                <h4 class="text-lg font-semibold text-primary mb-4"><i><?php echo number_format($proposal['min_price']) . " - " . number_format($proposal['max_price']);?> PHP</i></h4>
                
                <div class="bg-gray-50 rounded-xl shadow-inner mt-4">
                  <div class="bg-accent text-white px-5 py-3 rounded-t-xl">
                    <h3 class="text-lg font-semibold">Offers for this Proposal</h3>
                  </div>
                  <div class="p-6 space-y-4 h-64 overflow-y-auto">
                    <?php $getOffersByProposalID = $offerObj->getOffersByProposalID($proposal['proposal_id']); ?>
                    <?php if (empty($getOffersByProposalID)) { ?>
                        <p class="text-gray-500 text-center">No offers yet.</p>
                    <?php } else { ?>
                        <?php foreach ($getOffersByProposalID as $offer) { ?>
                        <div class="border-b border-gray-200 pb-3">
                          <h4 class="font-semibold"><?php echo $offer['username']; ?> <span class="text-primary font-normal">(<?php echo $offer['contact_number']; ?>)</span></h4>
                          <small class="text-gray-500"><i><?php echo date("F j, Y, g:i a", strtotime($offer['offer_date_added'])); ?></i></small>
                          <p class="text-gray-700 mt-1"><?php echo $offer['description']; ?></p>
                        </div>
                        <?php } ?>
                    <?php } ?>
                  </div>
                </div>

              </div>
            </div>
          </div>
        </div>
        <?php } ?>
      </div>
    </main>

    <!-- footer -->
    <footer class="bg-primary text-white text-center py-4 mt-auto">
      <p>&copy; <?php echo date("Y"); ?> FiverrClone. All rights reserved.</p>
    </footer>

  </body>
</html>