<?php require_once 'classloader.php'; ?>
<?php 
if (!$userObj->isLoggedIn()) {
  header("Location: login.php");
}

if (!$userObj->isClient() && !$userObj->isAdmin()) {
  header("Location: ../freelancer/index.php");
} 
?>
<!doctype html>
  <html lang="en">
  <head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Instrument+Sans:wght@400;600&display=swap" rel="stylesheet">

    <style>
      :root {
        --primary: #6CA6CD; 
        --accent: #F2C94C;  
        --light: #FDFDF6; 
      }
      body {
        font-family: 'Instrument Sans', sans-serif;
      }
      .bg-primary { background-color: var(--primary); }
      .bg-accent { background-color: var(--accent); }
      .bg-light { background-color: var(--light); }
      .text-primary { color: var(--primary); }
    </style>
  </head>
  <body class="bg-light min-h-screen flex flex-col">
    <?php include 'includes/navbar.php'; ?>

    <!-- main content -->
    <main class="container mx-auto px-6 py-12 flex-grow">
      <h2 class="text-2xl font-semibold text-primary text-center mb-10">Submitted Project Offers</h2>

      <div class="max-w-6xl mx-auto">
        <div class="bg-white rounded-xl shadow-md overflow-hidden">
          <div class="bg-accent text-white px-5 py-3">
            <h4 class="font-semibold">Your Offers</h4>
          </div>
          <div class="overflow-x-auto">
            <table class="min-w-full">
              <thead class="bg-gray-50">
                <tr>
                  <th class="px-4 py-3 text-left text-sm font-semibold text-gray-600">Proposal</th>
                  <th class="px-4 py-3 text-left text-sm font-semibold text-gray-600">Description</th>
                  <th class="px-4 py-3 text-left text-sm font-semibold text-gray-600">Date Submitted</th>
                  <th class="px-4 py-3 text-left text-sm font-semibold text-gray-600">Actions</th>
                </tr>
              </thead>
              <tbody class="divide-y divide-gray-100 text-sm">
                <?php 
                // Assuming you have a method to get offers by the current user's ID
                $offers = $offerObj->getOffersByUserID($_SESSION['user_id']); 
                foreach ($offers as $offer): 
                ?>
                  <tr>
                    <td class="px-4 py-2 font-medium">
                        <?php 
                        // Assuming you have a method to get proposal details by proposal_id
                        $proposal = $proposalObj->getProposals($offer['proposal_id']);
                        echo htmlspecialchars($proposal['description']); 
                        ?>
                    </td>
                    <td class="px-4 py-2"><?php echo htmlspecialchars($offer['description']); ?></td>
                    <td class="px-4 py-2"><?php echo date("F j, Y, g:i a", strtotime($offer['offer_date_added'])); ?></td>
                    <td class="px-4 py-2">
                      <form action="core/handleForms.php" method="POST">
                          <input type="hidden" name="offer_id" value="<?php echo $offer['offer_id']; ?>">
                          <button type="submit" name="deleteOfferBtn" class="text-red-500 hover:underline">Delete</button>
                      </form>
                    </td>
                  </tr>
                <?php endforeach; ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>

    </main>

    <!-- footer -->
    <footer class="bg-primary text-white text-center py-4 mt-auto">
      <p>&copy; <?php echo date("Y"); ?> FiverrClone. All rights reserved.</p>
    </footer>

  </body>
</html>