<?php require_once 'classloader.php'; ?>
<?php 
if (!$userObj->isLoggedIn()) {
  header("Location: login.php");
}

if (!$userObj->isClient() && !$userObj->isAdmin()) {
  header("Location: ../freelancer/index.php");
} 
?>
<!doctype html>
  <html lang="en">
  <head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Instrument+Sans:wght@400;600&display=swap" rel="stylesheet">

    <style>
      :root {
        --primary: #6CA6CD; 
        --accent: #F2C94C;  
        --light: #FDFDF6; 
      }
      body {
        font-family: 'Instrument Sans', sans-serif;
      }
      .bg-primary { background-color: var(--primary); }
      .bg-accent { background-color: var(--accent); }
      .bg-light { background-color: var(--light); }
      .text-primary { color: var(--primary); }
    </style>
  </head>
  <body class="bg-light min-h-screen flex flex-col">
    <?php include 'includes/navbar.php'; ?>
    <?php $userInfo = $userObj->getUsers($_SESSION['user_id']); ?>

    <!-- main content -->
    <main class="container mx-auto px-6 py-12 flex-grow">
      <h2 class="text-2xl font-semibold text-primary text-center mb-10">Your Profile</h2>

      <div class="grid md:grid-cols-2 gap-8 max-w-6xl mx-auto">
        
        <!-- Profile Information -->
        <div class="bg-white border border-gray-200 rounded-2xl shadow-md">
          <div class="bg-accent text-white px-5 py-3 rounded-t-2xl">
            <h3 class="text-lg font-semibold">Profile Details</h3>
          </div>
          <div class="p-6">
            <img src="https://cdn.pixabay.com/photo/2015/10/05/22/37/blank-profile-picture-973460_1280.png" class="w-32 h-32 rounded-full mx-auto mb-4" alt="">
            <h3 class="text-xl font-semibold text-center"><?php echo $userInfo['username']; ?></h3>
            <p class="text-gray-600 text-center"><?php echo $userInfo['email']; ?></p>
            <p class="text-gray-600 text-center mt-2"><?php echo $userInfo['contact_number']; ?></p>
            <p class="text-gray-700 mt-4 text-center"><i><?php echo $userInfo['bio_description']; ?></i></p>
          </div>
        </div>

        <!-- Update Profile Form -->
        <div class="bg-white border border-gray-200 rounded-2xl shadow-md">
          <div class="bg-accent text-white px-5 py-3 rounded-t-2xl">
            <h3 class="text-lg font-semibold">Update Your Profile</h3>
          </div>
          <div class="p-6">
            <form action="core/handleForms.php" method="POST" class="space-y-4">
              <div>
                <label for="username" class="block text-sm font-medium text-gray-700">Username</label>
                <input type="text" name="username" id="username" value="<?php echo $userInfo['username']; ?>" class="mt-1 block w-full px-3 py-2 bg-gray-100 border border-gray-300 rounded-md shadow-sm cursor-not-allowed" disabled>
              </div>
              <div>
                <label for="email" class="block text-sm font-medium text-gray-700">Email</label>
                <input type="email" name="email" id="email" value="<?php echo $userInfo['email']; ?>" class="mt-1 block w-full px-3 py-2 bg-gray-100 border border-gray-300 rounded-md shadow-sm cursor-not-allowed" disabled>
              </div>
              <div>
                <label for="contact_number" class="block text-sm font-medium text-gray-700">Contact Number</label>
                <input type="text" name="contact_number" id="contact_number" value="<?php echo $userInfo['contact_number']; ?>" class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-primary focus:border-primary" required>
              </div>
              <div>
                <label for="bio_description" class="block text-sm font-medium text-gray-700">Bio</label>
                <textarea name="bio_description" id="bio_description" rows="4" class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-primary focus:border-primary"><?php echo $userInfo['bio_description']; ?></textarea>
              </div>
              <div>
                <label for="display_picture" class="block text-sm font-medium text-gray-700">Display Picture</label>
                <input type="file" name="display_picture" id="display_picture" class="mt-1 block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-primary file:text-white hover:file:bg-primary-dark">
              </div>
              <div>
                <button type="submit" name="updateUserBtn" class="w-full flex justify-center py-2 px-4 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-primary hover:bg-primary-dark focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary">
                  Update Profile
                </button>
              </div>
            </form>
          </div>
        </div>

      </div>
    </main>

    <!-- footer -->
    <footer class="bg-primary text-white text-center py-4 mt-auto">
      <p>&copy; <?php echo date("Y"); ?> FiverrClone. All rights reserved.</p>
    </footer>

  </body>
</html>