<?php require_once 'classloader.php'; ?>

<!doctype html>
<html lang="en">
  <head>
    <!-- meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Instrument+Sans:wght@400;600&display=swap" rel="stylesheet">

    <style>
      :root {
        --primary: #6CA6CD; 
        --accent: #F2C94C; 
        --light: #FDFDF6;   
      }
      body {
        font-family: 'Instrument Sans', sans-serif;
        background-image: linear-gradient(to right, var(--primary), var(--accent));
      }
      .bg-primary { background-color: var(--primary); }
      .bg-accent { background-color: var(--accent); }
      .bg-light { background-color: var(--light); }
      .text-primary { color: var(--primary); }
    </style>
    <title>Client Login</title>
  </head>
  <body class="min-h-screen flex items-center justify-center py-8">
    <div class="w-full max-w-lg">
        <div class="text-center mb-8">
            <h1 class="text-4xl font-bold text-white mb-2">Fiverr Clone</h1>
            <p class="text-gray-200">Please login to continue</p>
        </div>
        <div class="bg-white rounded-xl shadow-md p-8">
            <h2 class="text-2xl font-semibold text-primary mb-6 text-center">Client Login</h2>
            <form action="core/handleForms.php" method="POST" class="space-y-6">
                <?php  
                if (isset($_SESSION['message']) && isset($_SESSION['status'])) {
                  if ($_SESSION['status'] == "200") {
                    echo "<div class='bg-green-100 text-green-800 border border-green-300 px-4 py-3 rounded-lg mb-6'>{$_SESSION['message']}</div>";
                  } else {
                    echo "<div class='bg-red-100 text-red-800 border border-red-300 px-4 py-3 rounded-lg mb-6'>{$_SESSION['message']}</div>"; 
                  }
                  unset($_SESSION['message']);
                  unset($_SESSION['status']);
                }
                ?>
                <div>
                    <label for="email" class="block font-medium text-gray-700 mb-1">Username</label>
                    <input type="email" id="email" name="email" required
                      class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-primary focus:border-primary"
                      placeholder="Enter your email">
                </div>
                <div>
                    <label for="password" class="block font-medium text-gray-700 mb-1">Password</label>
                    <input type="password" id="password" name="password" required
                      class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-primary focus:border-primary"
                      placeholder="Enter your password">
                </div>
                <button type="submit" name="loginUserBtn" class="w-full bg-primary text-white py-3 rounded-lg hover:bg-opacity-90 font-semibold">
                    Login
                </button>
            </form>
            <div class="mt-6 text-center">
                <p class="text-gray-600">Don't have an account yet? <a href="register.php" class="text-primary hover:underline font-medium">Register here!</a></p>
            </div>
        </div>
    </div>
  </body>
</html>
