<?php require_once 'classloader.php'; ?>
<?php 
if (!$userObj->isLoggedIn()) {
  header("Location: login.php");
}

if (!$userObj->isClient() && !$userObj->isAdmin()) {
  header("Location: ../freelancer/index.php");
} 
?>
<!doctype html>
  <html lang="en">
  <head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Instrument+Sans:wght@400;600&display=swap" rel="stylesheet">

    <style>
      :root {
        --primary: #6CA6CD; 
        --accent: #F2C94C;  
        --light: #FDFDF6; 
      }
      body {
        font-family: 'Instrument Sans', sans-serif;
      }
      .bg-primary { background-color: var(--primary); }
      .bg-accent { background-color: var(--accent); }
      .bg-light { background-color: var(--light); }
      .text-primary { color: var(--primary); }
    </style>
  </head>
  <body class="bg-light">
    <?php include 'includes/navbar.php'; ?>
    <div class="container mx-auto px-6 py-12">
        <div class="text-2xl font-semibold text-primary text-center mb-10">Hello there and welcome! <span class="text-green-500"><?php echo $_SESSION['username']; ?>. </span> Double click to edit your offers and then press enter to save!</div>
        <div class="text-center">
            <?php  
            if (isset($_SESSION['message']) && isset($_SESSION['status'])) {
                if ($_SESSION['status'] == "200") {
                echo "<div class='bg-green-100 text-green-800 border border-green-300 px-4 py-3 rounded-lg mb-6'>{$_SESSION['message']}</div>";
                } else {
                echo "<div class='bg-red-100 text-red-800 border border-red-300 px-4 py-3 rounded-lg mb-6'>{$_SESSION['message']}</div>"; 
                }
                unset($_SESSION['message']);
                unset($_SESSION['status']);
            }
            ?>
        </div>

        <div class="grid md:grid-cols-1 gap-8 max-w-6xl mx-auto">
            <?php $getProposals = $proposalObj->getProposals(); ?>
            <?php foreach ($getProposals as $proposal) { ?>
                <div class="bg-white border border-gray-200 rounded-2xl shadow-md ">
                    <div class="p-6">
                        <div class="grid md:grid-cols-2 gap-8">
                            <div>
                                <h2 class="text-2xl font-semibold text-primary mb-4"><a href="other_profile_view.php?user_id=<?php echo $proposal['user_id'] ?>"><?php echo $proposal['username']; ?></a></h2>
                                <img src="<?php echo '../images/'.$proposal['image']; ?>" class="w-full h-auto rounded-lg mb-4">
                                <p class="text-gray-700 mb-4"><?php echo $proposal['description']; ?></p>
                                <h4 class="text-lg font-semibold text-primary"><i><?php echo number_format($proposal['min_price']) . " - " . number_format($proposal['max_price']);?> PHP</i></h4>
                            </div>
                            <div>
                                <div class="bg-gray-50 rounded-xl shadow-inner" style="height: 600px;">
                                    <div class="bg-accent text-white px-5 py-3 rounded-t-xl">
                                        <h3 class="text-lg font-semibold">All Offers</h3>
                                    </div>
                                    <div class="p-6 overflow-auto h-full">
                                        <?php $getOffersByProposalID = $offerObj->getOffersByProposalID($proposal['proposal_id']); ?>
                                        <?php foreach ($getOffersByProposalID as $offer) { ?>
                                            <div class="offer mb-4 pb-4 border-b border-gray-200">
                                                <h4 class="text-lg font-semibold"><?php echo $offer['username']; ?> <span class="text-primary">( <?php echo $offer['contact_number']; ?> )</span></h4>
                                                <small class="text-gray-500"><i><?php echo $offer['offer_date_added']; ?></i></small>
                                                <p class="text-gray-700 mt-2"><?php echo $offer['description']; ?></p>

                                                <?php if ($offer['user_id'] == $_SESSION['user_id']) { ?>
                                                    <form action="core/handleForms.php" method="POST" class="mt-2">
                                                        <input type="hidden" value="<?php echo $offer['offer_id']; ?>" name="offer_id">
                                                        <button type="submit" name="deleteOfferBtn" class="text-red-500 hover:underline">Delete</button>
                                                    </form>

                                                    <form action="core/handleForms.php" method="POST" class="updateOfferForm hidden mt-2">
                                                        <div class="space-y-2">
                                                            <label for="description" class="block font-medium text-gray-700 mb-1">Description</label>
                                                            <input type="text" value="<?php echo $offer['description']; ?>" name="description" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-primary focus:border-primary">
                                                            <input type="hidden" value="<?php echo $offer['offer_id']; ?>" name="offer_id">
                                                            <button type="submit" name="updateOfferBtn" class="w-full bg-primary text-white py-2 rounded-lg hover:bg-opacity-90 font-semibold">Update</button>
                                                        </div>
                                                    </form>
                                                <?php } ?>
                                            </div>
                                        <?php } ?>
                                    </div>
                                    <div class="bg-gray-100 px-5 py-3 rounded-b-xl">
                                        <form action="core/handleForms.php" method="POST" class="space-y-2">
                                            <div>
                                                <label for="description" class="block font-medium text-gray-700 mb-1">Description</label>
                                                <input type="text" name="description" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-primary focus:border-primary">
                                                <input type="hidden" name="proposal_id" value="<?php echo $proposal['proposal_id']; ?>">
                                            </div>
                                            <button type="submit" name="insertOfferBtn" class="w-full bg-primary text-white py-2 rounded-lg hover:bg-opacity-90 font-semibold">Submit Offer</button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
    </div>
    <script>
       document.querySelectorAll('.offer').forEach(offer => {
            offer.addEventListener('dblclick', function (event) {
                const updateOfferForm = this.querySelector('.updateOfferForm');
                updateOfferForm.classList.toggle('hidden');
            });
        });
    </script>
  </body>
</html>