<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Instrument+Sans:wght@400;600&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: #6CA6CD; 
            --accent: #F2C94C;  
            --light: #FDFDF6;   
        }
        body {
            font-family: 'Instrument Sans', sans-serif;
        }
        .bg-primary { background-color: var(--primary); }
        .bg-accent { background-color: var(--accent); }
        .bg-light { background-color: var(--light); }
        .text-primary { color: var(--primary); }
    </style>
</head>
<body class="bg-light min-h-screen flex flex-col">

    <header class="bg-primary text-white py-6 shadow-md">
        <div class="container mx-auto px-6 flex justify-between items-center">
            <h1 class="text-3xl font-bold">Fiverr Clone</h1>
        </div>
    </header>

    <main class="container mx-auto px-6 py-12 flex-grow">
        <h2 class="text-2xl font-semibold text-primary text-center mb-10">Welcome to the Fiverr Clone!</h2>

        <div class="grid md:grid-cols-2 gap-8 max-w-6xl mx-auto">
            <a href="../2_fiverr_clone/client/login.php" class="block bg-white border border-gray-200 rounded-2xl shadow-md hover:shadow-lg hover:scale-[1.02] transition transform duration-200">
                <div class="bg-accent text-white px-5 py-3 rounded-t-2xl">
                    <h3 class="text-lg font-semibold">Are you looking for a talent?</h3>
                </div>
                <div class="p-6">
                    <img src="https://images.unsplash.com/photo-1549923746-c502d488b3ea?q=80&w=1171&auto=format&fit=crop&ixlib=rb-4.1.0&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D" class="img-fluid rounded-lg mb-4">
                    <p class="text-gray-700 mb-4">
                        Content writers create clear, engaging, and informative content that helps businesses communicate their services or products effectively, build brand authority, attract and retain customers, and drive web traffic and conversions.
                    </p>
                    <div class="inline-block bg-primary text-white px-5 py-2 rounded-full font-semibold text-sm">
                        Get started here as client
                    </div>
                </div>
            </a>

            <a href="../2_fiverr_clone/freelancer/login.php" class="block bg-white border border-gray-200 rounded-2xl shadow-md hover:shadow-lg hover:scale-[1.02] transition transform duration-200">
                <div class="bg-accent text-white px-5 py-3 rounded-t-2xl">
                    <h3 class="text-lg font-semibold">Are you looking for a job?</h3>
                </div>
                <div class="p-6">
                    <img src="https://plus.unsplash.com/premium_photo-1661582394864-ebf82b779eb0?q=80&w=1170&auto=format&fit=crop&ixlib=rb-4.1.0&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D" class="img-fluid rounded-lg mb-4">
                    <p class="text-gray-700 mb-4">
                        Admin writers play a key role in content team development. They are the highest-ranking editorial authority responsible for managing the entire editorial process, and aligning all published material with the publication’s overall vision and strategy.
                    </p>
                    <div class="inline-block bg-primary text-white px-5 py-2 rounded-full font-semibold text-sm">
                        Get started here as freelancer
                    </div>
                </div>
            </a>
        </div>

        <div class="mt-12 max-w-6xl mx-auto">
            <h3 class="text-xl font-semibold text-primary mb-6 text-center">Testimonials From Users</h3>
            <div class="grid md:grid-cols-3 gap-8">
                <div class="bg-white rounded-xl shadow-md overflow-hidden">
                    <img src="https://images.unsplash.com/photo-1508214751196-bcfd4ca60f91?auto=format&fit=crop&w=600&q=80" class="w-full h-48 object-cover">
                    <div class="p-6">
                        <h5 class="text-lg font-semibold">Sophia M.</h5>
                        <p class="text-gray-700 mt-2">This talent search app helped me discover amazing job opportunities quickly. The personalized matches made all the difference!</p>
                    </div>
                </div>
                <div class="bg-white rounded-xl shadow-md overflow-hidden">
                    <img src="https://images.unsplash.com/photo-1524504388940-b1c1722653e1?auto=format&fit=crop&w=600&q=80" class="w-full h-48 object-cover">
                    <div class="p-6">
                        <h5 class="text-lg font-semibold">Liam K.</h5>
                        <p class="text-gray-700 mt-2">Easy to use and very effective. Found a great match for my skills within a week. Highly recommend for job seekers.</p>
                    </div>
                </div>
                <div class="bg-white rounded-xl shadow-md overflow-hidden">
                    <img src="https://images.unsplash.com/photo-1520813792240-56fc4a3765a7?auto=format&fit=crop&w=600&q=80" class="w-full h-48 object-cover">
                    <div class="p-6">
                        <h5 class="text-lg font-semibold">Emma T.</h5>
                        <p class="text-gray-700 mt-2">The app’s user interface is smooth and the application process was seamless. It really boosted my career search experience.</p>
                    </div>
                </div>
                <div class="bg-white rounded-xl shadow-md overflow-hidden">
                    <img src="https://images.unsplash.com/photo-1544005313-94ddf0286df2?auto=format&fit=crop&w=600&q=80" class="w-full h-48 object-cover">
                    <div class="p-6">
                        <h5 class="text-lg font-semibold">Olivia W.</h5>
                        <p class="text-gray-700 mt-2">I love how the app customizes recommendations based on my profile. It truly feels personalized and effective.</p>
                    </div>
                </div>
                <div class="bg-white rounded-xl shadow-md overflow-hidden">
                    <img src="https://images.unsplash.com/photo-1511367461989-f85a21fda167?auto=format&fit=crop&w=600&q=80" class="w-full h-48 object-cover">
                    <div class="p-6">
                        <h5 class="text-lg font-semibold">Ethan L.</h5>
                        <p class="text-gray-700 mt-2">The interview scheduling feature saved me so much time. The app is intuitive and recruiter communication is excellent.</p>
                    </div>
                </div>
                <div class="bg-white rounded-xl shadow-md overflow-hidden">
                    <img src="https://images.unsplash.com/photo-1527980965255-d3b416303d12?auto=format&fit=crop&w=600&q=80" class="w-full h-48 object-cover">
                    <div class="p-6">
                        <h5 class="text-lg font-semibold">Adam R.</h5>
                        <p class="text-gray-700 mt-2">Found roles that matched my skill set perfectly. The app helped me showcase my talents in the best light. So thankful!</p>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <footer class="bg-primary text-white text-center py-4 mt-auto">
        <p>&copy; 2025 Fiverr Clone</p>
    </footer>

</body>
</html>