<?php
require_once __DIR__ . '/../client/classloader.php';
require_once __DIR__ . '/classes/Subcategory.php';
require_once __DIR__ . '/classes/Category.php';

$userObj = new User();
$category = new Category(); 
$subcategory = new Subcategory();

if (!$userObj->isLoggedIn() || !$userObj->isAdmin()) {
    header('Location: /FiverrClone/client/login.php');
    exit();
}

$subcategory_name = '';
$category_id = '';
$subcategory_id = null;
$is_edit = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['save_subcategory'])) {
        $subcategory_name = $_POST['subcategory_name'];
        $category_id = $_POST['category_id'];
        $subcategory->createSubcategory($subcategory_name, $category_id);
        header('Location: subcategories.php');
        exit();
    } elseif (isset($_POST['update_subcategory'])) {
        $subcategory_id = $_POST['subcategory_id'];
        $subcategory_name = $_POST['subcategory_name'];
        $category_id = $_POST['category_id'];
        $subcategory->updateSubcategory($subcategory_id, $subcategory_name, $category_id);
        header('Location: subcategories.php');
        exit();
    }
}

if (isset($_GET['delete'])) {
    $subcategory_id = $_GET['delete'];
    $subcategory->deleteSubcategory($subcategory_id);
    header('Location: subcategories.php');
    exit();
}

if (isset($_GET['edit'])) {
    $is_edit = true;
    $subcategory_id = $_GET['edit'];
    $subcat = $subcategory->getSubcategory($subcategory_id);
    $subcategory_name = $subcat['subcategory_name'];
    $category_id = $subcat['category_id'];
}

$categories = $category->getCategories();
$subcategories = $subcategory->getSubcategories();

require_once __DIR__ . '/includes/_header.php';

?>

<h2 class="text-2xl font-semibold text-primary text-center mb-10">Manage Subcategories</h2>

<div class="grid md:grid-cols-3 gap-8 max-w-7xl mx-auto">

    <!-- Add/Edit Subcategory Form -->
    <div class="md:col-span-1">
        <div class="bg-white border border-gray-200 rounded-2xl shadow-md">
            <div class="bg-accent text-white px-5 py-3 rounded-t-2xl">
                <h3 class="text-lg font-semibold"><?php echo $is_edit ? 'Edit Subcategory' : 'Add New Subcategory'; ?></h3>
            </div>
            <div class="p-6">
                <form action="subcategories.php" method="post" class="space-y-4">
                    <div>
                        <label for="category_id" class="block text-sm font-medium text-gray-700">Category</label>
                        <select name="category_id" id="category_id" class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-primary focus:border-primary" required>
                            <option value="">Select Category</option>
                            <?php foreach ($categories as $cat): ?>
                                <option value="<?php echo $cat['category_id']; ?>" <?php echo ($category_id == $cat['category_id']) ? 'selected' : ''; ?>><?php echo htmlspecialchars($cat['category_name']); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div>
                        <label for="subcategory_name" class="block text-sm font-medium text-gray-700">Subcategory Name</label>
                        <input type="text" name="subcategory_name" id="subcategory_name" class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-primary focus:border-primary" value="<?php echo htmlspecialchars($subcategory_name); ?>" required>
                    </div>
                    <div>
                        <?php if ($is_edit): ?>
                            <input type="hidden" name="subcategory_id" value="<?php echo $subcategory_id; ?>">
                            <button type="submit" name="update_subcategory" class="w-full flex justify-center py-2 px-4 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-primary hover:bg-primary-dark focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary">
                                Update Subcategory
                            </button>
                        <?php else: ?>
                            <button type="submit" name="save_subcategory" class="w-full flex justify-center py-2 px-4 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-primary hover:bg-primary-dark focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary">
                                Save Subcategory
                            </button>
                        <?php endif; ?>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Subcategories Table -->
    <div class="md:col-span-2">
        <div class="bg-white rounded-xl shadow-md overflow-hidden">
            <div class="bg-accent text-white px-5 py-3">
                <h4 class="font-semibold">All Subcategories (<?php echo count($subcategories); ?>)</h4>
            </div>
            <div class="overflow-x-auto">
                <table class="min-w-full">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-4 py-3 text-left text-sm font-semibold text-gray-600">Subcategory Name</th>
                            <th class="px-4 py-3 text-left text-sm font-semibold text-gray-600">Category</th>
                            <th class="px-4 py-3 text-left text-sm font-semibold text-gray-600">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100 text-sm">
                        <?php foreach ($subcategories as $subcat): ?>
                            <tr>
                                <td class="px-4 py-2 font-medium"><?php echo htmlspecialchars($subcat['subcategory_name']); ?></td>
                                <td class="px-4 py-2"><?php echo htmlspecialchars($subcat['category_name']); ?></td>
                                <td class="px-4 py-2 space-x-2">
                                    <a href="subcategories.php?edit=<?php echo $subcat['subcategory_id']; ?>" class="text-blue-500 hover:underline">Edit</a>
                                    <a href="subcategories.php?delete=<?php echo $subcat['subcategory_id']; ?>" class="text-red-500 hover:underline" onclick="return confirm('Are you sure you want to delete this subcategory?');">Delete</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

</div>

<?php require_once __DIR__ . '/includes/_footer.php'; ?>