<?php 
require_once __DIR__ . '/../client/classloader.php';
require_once __DIR__ . '/classes/Category.php';

$userObj = new User();
if (!$userObj->isLoggedIn() || !$userObj->isAdmin()) {
    header('Location: /FiverrClone/client/login.php');
    exit();
}

$proposalObj = new Proposal();
$offerObj = new Offer();

// Filtering logic
if (isset($_GET['category_id'])) {
    $proposals = $proposalObj->getProposalsByCategoryId($_GET['category_id']);
} elseif (isset($_GET['subcategory_id'])) {
    $proposals = $proposalObj->getProposalsBySubcategoryId($_GET['subcategory_id']);
} else {
    $proposals = $proposalObj->getProposals();
}

$offers = $offerObj->getOffers();

require_once __DIR__ . '/includes/_header.php'; 

?>

<h2 class="text-2xl font-semibold text-primary text-center mb-10">Admin Dashboard</h2>

<!-- Proposals Table -->
<div class="bg-white rounded-xl shadow-md overflow-hidden mb-8">
  <div class="bg-accent text-white px-5 py-3">
    <h4 class="font-semibold">All Proposals (<?php echo count($proposals); ?>)</h4>
  </div>
  <div class="overflow-x-auto">
    <table class="min-w-full">
      <thead class="bg-gray-50">
        <tr>
          <th class="px-4 py-3 text-left text-sm font-semibold text-gray-600">ID</th>
          <th class="px-4 py-3 text-left text-sm font-semibold text-gray-600">User</th>
          <th class="px-4 py-3 text-left text-sm font-semibold text-gray-600">Description</th>
          <th class="px-4 py-3 text-left text-sm font-semibold text-gray-600">Category</th>
          <th class="px-4 py-3 text-left text-sm font-semibold text-gray-600">Subcategory</th>
          <th class="px-4 py-3 text-left text-sm font-semibold text-gray-600">Price Range</th>
          <th class="px-4 py-3 text-left text-sm font-semibold text-gray-600">Date Added</th>
        </tr>
      </thead>
      <tbody class="divide-y divide-gray-100 text-sm">
        <?php foreach ($proposals as $proposal): ?>
        <tr>
          <td class="px-4 py-2 font-medium"><?php echo htmlspecialchars($proposal['proposal_id']); ?></td>
          <td class="px-4 py-2"><?php echo htmlspecialchars($proposal['username']); ?></td>
          <td class="px-4 py-2"><?php echo htmlspecialchars($proposal['description']); ?></td>
          <td class="px-4 py-2"><?php echo htmlspecialchars($proposal['category_name'] ?? 'N/A'); ?></td>
          <td class="px-4 py-2"><?php echo htmlspecialchars($proposal['subcategory_name'] ?? 'N/A'); ?></td>
          <td class="px-4 py-2">$<?php echo htmlspecialchars($proposal['min_price']); ?> - $<?php echo htmlspecialchars($proposal['max_price']); ?></td>
          <td class="px-4 py-2"><?php echo date("F j, Y, g:i a", strtotime($proposal['proposals_date_added'])); ?></td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>

<!-- Offers Table -->
<div id="offers" class="bg-white rounded-xl shadow-md overflow-hidden">
  <div class="bg-accent text-white px-5 py-3">
    <h4 class="font-semibold">All Offers (<?php echo count($offers); ?>)</h4>
  </div>
  <div class="overflow-x-auto">
    <table class="min-w-full">
      <thead class="bg-gray-50">
        <tr>
          <th class="px-4 py-3 text-left text-sm font-semibold text-gray-600">ID</th>
          <th class="px-4 py-3 text-left text-sm font-semibold text-gray-600">User</th>
          <th class="px-4 py-3 text-left text-sm font-semibold text-gray-600">Proposal ID</th>
          <th class="px-4 py-3 text-left text-sm font-semibold text-gray-600">Description</th>
          <th class="px-4 py-3 text-left text-sm font-semibold text-gray-600">Date Added</th>
        </tr>
      </thead>
      <tbody class="divide-y divide-gray-100 text-sm">
        <?php foreach ($offers as $offer): ?>
        <tr>
          <td class="px-4 py-2 font-medium"><?php echo htmlspecialchars($offer['offer_id']); ?></td>
          <td class="px-4 py-2"><?php echo htmlspecialchars($offer['username']); ?></td>
          <td class="px-4 py-2"><?php echo htmlspecialchars($offer['proposal_id']); ?></td>
          <td class="px-4 py-2"><?php echo htmlspecialchars($offer['description']); ?></td>
          <td class="px-4 py-2"><?php echo date("F j, Y, g:i a", strtotime($offer['offer_date_added'])); ?></td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>

<?php require_once __DIR__ . '/includes/_footer.php'; ?>