<?php
$categoryObjForNav = new Category();
$categoriesForNav = $categoryObjForNav->getCategoriesWithSubcategories();
$currentPage = basename($_SERVER['SCRIPT_NAME']);
?>
<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <script src="https://cdn.tailwindcss.com"></script>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <link href="https://fonts.googleapis.com/css2?family=Instrument+Sans:wght@400;600&display=swap" rel="stylesheet">
    <title>Admin Dashboard</title>
    <style>
      :root {
        --primary: #6CA6CD;
        --accent: #F2C94C;
        --light: #FDFDF6;
      }
      body {
        font-family: 'Instrument Sans', sans-serif;
      }
      .bg-primary { background-color: var(--primary); }
      .bg-accent { background-color: var(--accent); }
      .bg-light { background-color: var(--light); }
      .text-primary { color: var(--primary); }
    </style>
</head>
<body class="bg-light min-h-screen flex flex-col">

  <!-- header -->
  <header class="bg-primary text-white py-6 shadow-md">
    <div class="container mx-auto px-6 flex justify-between items-center">
      <h1 class="text-3xl font-bold">Admin Panel</h1>
      <div class="flex items-center gap-4">
        <a href="logout.php" class="bg-white text-primary px-4 py-2 rounded-lg hover:bg-gray-100 font-medium text-sm">
          &#128682; Logout
        </a>
      </div>
    </div>
  </header>

  <!-- navigation -->
  <nav class="bg-white border-b border-gray-200 shadow-sm">
    <div class="container mx-auto px-6 py-3 flex justify-center gap-6">
      <a href="index.php" class="<?php echo ($currentPage == 'index.php') ? 'text-primary font-semibold' : 'text-gray-700 hover:text-primary font-medium'; ?>">&#127968; Dashboard</a>
      <div class="relative" x-data="{ open: false }">
        <button @click="open = !open" class="<?php echo ($currentPage == 'index.php') ? 'text-primary font-semibold' : 'text-gray-700 hover:text-primary font-medium'; ?> focus:outline-none">
          Proposals
        </button>
        <div x-show="open" @click.away="open = false" x-cloak class="absolute z-10 mt-2 w-56 rounded-md shadow-lg bg-white ring-1 ring-black ring-opacity-5">
          <div class="py-1" role="menu" aria-orientation="vertical" aria-labelledby="options-menu">
            <a href="index.php" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100" role="menuitem">All Proposals</a>
            <?php foreach ($categoriesForNav as $category): ?>
              <div class="relative" x-data="{ subOpen: false }" @mouseenter="subOpen = true" @mouseleave="subOpen = false">
                <a href="index.php?category_id=<?php echo $category['category_id']; ?>" class="flex justify-between items-center w-full px-4 py-2 text-sm text-gray-700 hover:bg-gray-100" role="menuitem">
                  <span><?php echo htmlspecialchars($category['category_name']); ?></span>
                  <?php if (!empty($category['subcategories'])): ?>
                    <span>&rsaquo;</span>
                  <?php endif; ?>
                </a>
                <?php if (!empty($category['subcategories'])): ?>
                  <div x-show="subOpen" class="absolute z-10 left-full top-0 mt-0 w-56 rounded-md shadow-lg bg-white ring-1 ring-black ring-opacity-5">
                    <div class="py-1" role="menu" aria-orientation="vertical" aria-labelledby="options-menu">
                      <?php foreach ($category['subcategories'] as $sub): ?>
                        <a href="index.php?subcategory_id=<?php echo $sub['subcategory_id']; ?>" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100" role="menuitem"><?php echo htmlspecialchars($sub['subcategory_name']); ?></a>
                      <?php endforeach; ?>
                    </div>
                  </div>
                <?php endif; ?>
              </div>
            <?php endforeach; ?>
          </div>
        </div>
      </div>
      <a href="categories.php" class="<?php echo ($currentPage == 'categories.php') ? 'text-primary font-semibold' : 'text-gray-700 hover:text-primary font-medium'; ?>">&#128203; Categories</a>
      <a href="subcategories.php" class="<?php echo ($currentPage == 'subcategories.php') ? 'text-primary font-semibold' : 'text-gray-700 hover:text-primary font-medium'; ?>">&#128204; Subcategories</a>
    </div>
  </nav>

<main class="container mx-auto px-6 py-12 flex-grow">