<?php
require_once __DIR__ . '/../client/classloader.php';
require_once __DIR__ . '/classes/Category.php';

$userObj = new User();
$category = new Category();

if (!$userObj->isLoggedIn() || !$userObj->isAdmin()) {
    header('Location: /FiverrClone/client/login.php');
    exit();
}

$category_name = '';
$category_id = null;
$is_edit = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['save_category'])) {
        $category_name = $_POST['category_name'];
        $category->createCategory($category_name);
        header('Location: categories.php');
        exit();
    } elseif (isset($_POST['update_category'])) {
        $category_id = $_POST['category_id'];
        $category_name = $_POST['category_name'];
        $category->updateCategory($category_id, $category_name);
        header('Location: categories.php');
        exit();
    }
}

if (isset($_GET['delete'])) {
    $category_id = $_GET['delete'];
    $category->deleteCategory($category_id);
    header('Location: categories.php');
    exit();
}

if (isset($_GET['edit'])) {
    $is_edit = true;
    $category_id = $_GET['edit'];
    $cat = $category->getCategory($category_id);
    $category_name = $cat['category_name'];
}

$categories = $category->getCategories();

require_once __DIR__ . '/includes/_header.php';

?>

<h2 class="text-2xl font-semibold text-primary text-center mb-10">Manage Categories</h2>

<div class="grid md:grid-cols-3 gap-8 max-w-7xl mx-auto">

    <!-- Add/Edit Category Form -->
    <div class="md:col-span-1">
        <div class="bg-white border border-gray-200 rounded-2xl shadow-md">
            <div class="bg-accent text-white px-5 py-3 rounded-t-2xl">
                <h3 class="text-lg font-semibold"><?php echo $is_edit ? 'Edit Category' : 'Add New Category'; ?></h3>
            </div>
            <div class="p-6">
                <form action="categories.php" method="post" class="space-y-4">
                    <div>
                        <label for="category_name" class="block text-sm font-medium text-gray-700">Category Name</label>
                        <input type="text" name="category_name" id="category_name" class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-primary focus:border-primary" value="<?php echo htmlspecialchars($category_name); ?>" required>
                    </div>
                    <div>
                        <?php if ($is_edit): ?>
                            <input type="hidden" name="category_id" value="<?php echo $category_id; ?>">
                            <button type="submit" name="update_category" class="w-full flex justify-center py-2 px-4 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-primary hover:bg-primary-dark focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary">
                                Update Category
                            </button>
                        <?php else: ?>
                            <button type="submit" name="save_category" class="w-full flex justify-center py-2 px-4 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-primary hover:bg-primary-dark focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary">
                                Save Category
                            </button>
                        <?php endif; ?>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Categories Table -->
    <div class="md:col-span-2">
        <div class="bg-white rounded-xl shadow-md overflow-hidden">
            <div class="bg-accent text-white px-5 py-3">
                <h4 class="font-semibold">All Categories (<?php echo count($categories); ?>)</h4>
            </div>
            <div class="overflow-x-auto">
                <table class="min-w-full">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-4 py-3 text-left text-sm font-semibold text-gray-600">Category Name</th>
                            <th class="px-4 py-3 text-left text-sm font-semibold text-gray-600">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100 text-sm">
                        <?php foreach ($categories as $cat): ?>
                            <tr>
                                <td class="px-4 py-2 font-medium"><?php echo htmlspecialchars($cat['category_name']); ?></td>
                                <td class="px-4 py-2 space-x-2">
                                    <a href="categories.php?edit=<?php echo $cat['category_id']; ?>" class="text-blue-500 hover:underline">Edit</a>
                                    <a href="categories.php?delete=<?php echo $cat['category_id']; ?>" class="text-red-500 hover:underline" onclick="return confirm('Are you sure you want to delete this category?');">Delete</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

</div>

<?php require_once __DIR__ . '/includes/_footer.php'; ?>